import { Component } from '@angular/core';

import { HomePage } from '../home/home';
import { SettingPage } from "../setting/setting";
import { SearchPage } from "../search/search";
import { CartPage } from "../cart/cart";
import { FavoritePage } from "../favorite/favorite";

@Component({
  templateUrl: 'tabs.html'
})
export class TabsPage {

  tab1Root = HomePage;
  tab2Root = SearchPage;
  tab3Root = CartPage;
  tab4Root = FavoritePage;
  tab5Root = SettingPage;

  constructor() {

  }

  countBadgeCart() {
    let cart = JSON.parse(window.localStorage.getItem('e3cart'));
    let length = 0;
    if (cart && cart.items) {
      let cartLength = cart.items ? cart.items.length : 0;
      for (let i = 0; i < cartLength; i++) {
        length += cart.items[i].qty;
      }
    }
    window.localStorage.setItem('e3cartBadge', length.toString());
    return length > 0 ? length.toString() : '';
  }

}
