import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { CategoryListModel } from '../../models/pages/category.model';

/*
  Generated class for the CategoryServiceProvider provider.

  See https://angular.io/docs/ts/latest/guide/dependency-injection.html
  for more info on providers and Angular DI.
*/
@Injectable()
export class CategoryServiceProvider {

  constructor(public http: Http) {
    console.log('Hello CategoryServiceProvider Provider');
  }

  getCategoryData(): Promise<CategoryListModel> {
    return this.http.get('./assets/json/category.json')
      .toPromise()
      .then(response => response.json() as CategoryListModel)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    return Promise.reject(error.message || error);
  }

}
