import { Component, ViewChild, Output, EventEmitter } from '@angular/core';
import { Slides } from "ionic-angular";

/**
 * Generated class for the FormWizardComponent component.
 *
 * See https://angular.io/docs/ts/latest/api/core/index/ComponentMetadata-class.html
 * for more info on Angular Components.
 */
@Component({
  selector: 'form-wizard',
  templateUrl: 'form-wizard.html'
})
export class FormWizardComponent {
  @ViewChild('formWizard') formWizard: Slides;
  @Output() confirmed: EventEmitter<any> = new EventEmitter();
  tabs: any = '0';
  constructor() {
    console.log('Hello FormWizardComponent Component');
  }

  changeWillSlide($event) {
    this.tabs = $event._snapIndex.toString();
  }

  ngAfterViewInit() {
    this.formWizard.lockSwipes(true);
  }

  slidePrev() {
    this.formWizard.lockSwipes(false);
    this.formWizard.slidePrev();
    this.formWizard.lockSwipes(true);
  }

  slideNext() {
    this.formWizard.lockSwipes(false);
    this.formWizard.slideNext();
    this.formWizard.lockSwipes(true);
  }

  clickConfirmed() {
    this.confirmed.emit();
  }

}
