import { Component } from '@angular/core';
import { NavController, NavParams } from 'ionic-angular';
import { CategoryServiceProvider } from '../../providers/category-service/category-service';
import { CategoryListModel } from '../../models/pages/category.model';
import { ProductListPage } from '../product-list/product-list';
import { LoadingProvider } from '../../providers/loading/loading';

/**
 * Generated class for the CategoryPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-category',
  templateUrl: 'category.html',
})
export class CategoryPage {

  categories: CategoryListModel = new CategoryListModel();

  constructor(
    public navCtrl: NavController, 
    public navParams: NavParams, 
    public categoryServiceProvider: CategoryServiceProvider,
    public loadingProvider: LoadingProvider) {
  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad CategoryPage');
    this.getCategory();
  }

  getCategory() {
    this.loadingProvider.onLoading();
    
    this.categoryServiceProvider.getCategoryData().then((data) => {
      this.categories = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      console.log(error);
      this.loadingProvider.dismiss();      
    });
  }

  goToProductList() {
    this.navCtrl.push(ProductListPage);
  }

}
