import { Component, ElementRef } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { ProductDetailPage } from "../product-detail/product-detail";

import { HeaderContentProvider } from "../../providers/header-content/header-content";
import { FavoriteServiceProvider } from "../../providers/favorite-service/favorite-service";
import { ProductListModel } from "../../models/pages/product-list.model";
import { LoadingProvider } from '../../providers/loading/loading';

/**
 * Generated class for the FavoritePage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-favorite',
  templateUrl: 'favorite.html',
})
export class FavoritePage {
  ionScroll: any;
  start: number = 0;
  slideHeaderPrevious: number = 0;
  hideheader: boolean;
  showheader: boolean;

  favoriteData: ProductListModel = new ProductListModel();

  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public app: App,
    public myElement: ElementRef,
    public headerContentProvider: HeaderContentProvider,
    public favoriteServiceProvider: FavoriteServiceProvider,
    public loadingProvider: LoadingProvider) {
  }

  ionViewDidLoad() {
    console.log('FavoritePage');
    this.onHeaderScroll();
    this.getFavorite();
  }

  onHeaderScroll() {
    this.hideheader = false;
    this.showheader = true;
    this.ionScroll = this.myElement.nativeElement.getElementsByClassName('scroll-content')[0];
    this.ionScroll.addEventListener("scroll", () => {
      this.hideheader = this.headerContentProvider.getContent(this.ionScroll.scrollTop);
      this.showheader = !this.hideheader;
      if (this.slideHeaderPrevious >= this.ionScroll.scrollTop - this.start) {
        this.hideheader = false;
        this.showheader = true;
      }
      this.slideHeaderPrevious = this.ionScroll.scrollTop - this.start;
    });
  }

  getFavorite() {
    this.loadingProvider.onLoading();
    this.favoriteServiceProvider.getFavoriteData().then((data) => {
      this.favoriteData = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      console.log(error);
      this.loadingProvider.dismiss();
    });
  }


  goToDetail(item) {
    this.app.getRootNav().push(ProductDetailPage);
  }

  // addToCart() {
  //   window.event.stopPropagation();
  // }

}
