import { Component } from '@angular/core';
import { NavController, NavParams, App, LoadingController } from 'ionic-angular';

import { ProductDetailPage } from "../product-detail/product-detail";
import { ProductListServiceProvider } from "../../providers/product-list-service/product-list-service";
import { ProductListModel } from "../../models/pages/product-list.model";
import { LoadingProvider } from '../../providers/loading/loading';
/**
 * Generated class for the ProductListPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-product-list',
  templateUrl: 'product-list.html',
})
export class ProductListPage {
  productListData: ProductListModel = new ProductListModel();
  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public app: App,
    public productListServiceProvider: ProductListServiceProvider,
    public loadingCtrl: LoadingController,
    public loadingProvider: LoadingProvider) {
  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad ProductListPage');
    this.getProductList();
  }

  getProductList() {
    this.loadingProvider.onLoading();

    this.productListServiceProvider.getProductListData().then((data) => {
      this.productListData = data;
      setTimeout(() => {
        this.loadingProvider.dismiss();
      }, 1000);
    }, (error) => {
      console.log(error);
      setTimeout(() => {
        this.loadingProvider.dismiss();
      }, 1000);
    });
  }

  goToDetail() {
    this.app.getRootNav().push(ProductDetailPage);
  }

  getCount() {
    return window.localStorage.getItem('e3cartBadge');
  }

}
