import { Component, ElementRef } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { ProductDetailPage } from "../product-detail/product-detail";
import { ShopDetailPage } from "../shop-detail/shop-detail";

import { HeaderContentProvider } from "../../providers/header-content/header-content";

/**
 * Generated class for the SearchPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-search',
  templateUrl: 'search.html',
})
export class SearchPage {
  ionScroll: any;
  start: number = 0;
  slideHeaderPrevious: number = 0;
  hideheader: boolean;
  showheader: boolean;

  rate: Number = 4;
  product: Object = {
    name: 'iPhone 7',
    image: './assets/images/Iphone_7.jpg',
    unitprice: 26500,
    rate: 4
  };
  products: Array<Object> = [];
  shop: any = {
    image: './assets/images/ais.jpg',
    name: 'AIS',
    detail: 'iPhone 7 ที่เอไอเอส เริ่มต้นเพียง 25,500 บาท',
    rate: 4
  }
  shops: Array<any> = [];
  constructor(public navCtrl: NavController, public navParams: NavParams, public app: App, public myElement: ElementRef, public headerContentProvider: HeaderContentProvider) {
  }

  ionViewDidLoad() {
    console.log('SearchPage');
    this.onHeaderScroll();
    this.getHomeData();
  }

  onHeaderScroll() {
    this.hideheader = false;
    this.showheader = true;
    this.ionScroll = this.myElement.nativeElement.getElementsByClassName('scroll-content')[0];
    this.ionScroll.addEventListener("scroll", () => {
      this.hideheader = this.headerContentProvider.getContent(this.ionScroll.scrollTop);
      this.showheader = !this.hideheader;
      if (this.slideHeaderPrevious >= this.ionScroll.scrollTop - this.start) {
        this.hideheader = false;
        this.showheader = true;
      }
      this.slideHeaderPrevious = this.ionScroll.scrollTop - this.start;
    });
  }

  getHomeData() {
    for (let i = 0; i <= 10; i++) {
      this.products.push(this.product);
    }

    for (let i = 0; i < 3; i++) {
      this.shops.push(this.shop);
    }
  }

  goToShopDetail() {
    this.app.getRootNav().push(ShopDetailPage);
  }

  goToDetail(item) {
    this.app.getRootNav().push(ProductDetailPage);
  }

  addToCart() {
    window.event.stopPropagation();
  }

}
